/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.ArchivedServerCertBean;
import com.ibm.hwmca.fw.certs.ArchivedSigningCertBean;
import com.ibm.hwmca.fw.certs.CertMgtBean;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.CertSignReq;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.certs.ListBoxBean;
import com.ibm.hwmca.fw.certs.ModifyCertBean;
import com.ibm.hwmca.fw.certs.ModifyCertExpBean;
import com.ibm.hwmca.fw.certs.NewServerCertBean;
import com.ibm.hwmca.fw.certs.RemovableMediaChoiceBean;
import com.ibm.hwmca.fw.certs.SelfSignedServerCert;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.certs.SigningCertMgtBean;
import com.ibm.hwmca.fw.certs.SigningChoiceBean;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class CertMgtTasklet
extends PanelTasklet
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTMGCD";
    private static final String TRACE_MASKF = "XCRTMGCF";
    private static final String TRACE_MASKT = "XCRTMGCT";

    public CertMgtTasklet() {
        Trace.trace(TRACE_MASKT, "<->CertMgtTasklet()");
    }

    public static void main(String[] args) {
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "->init()");
        Trace.trace(TRACE_MASKT, "<-init()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block109: {
            String source = null;
            String actionCommand = null;
            Serializable data = null;
            Serializable data2 = null;
            ServerCert certificate = null;
            ServerCert archivedCertificate = null;
            Object subjectAltNames = null;
            HashMap<String, Serializable> taskletData = null;
            HashMap<String, Object> newTaskletData = null;
            SelfSignedServerCert partialServerCert = null;
            ServerCert tempCertificate = null;
            Object modifiedSubjectAltNames = null;
            boolean numOfDaysValid = false;
            CertPrincipal issuer = null;
            MediaDeviceIdentifier[] devices = null;
            ArrayList qualifiedDevices = null;
            String internalDeviceName = null;
            MediaDeviceIdentifier chosenDevice = null;
            CertSignReq certSignReq = null;
            File mediaMountPointFile = null;
            String mediaMountPoint = null;
            MediaDevice mediaDevice = null;
            LocalizableText answer = null;
            String hostName = null;
            File[] files = null;
            ArrayList<String> filesToList = null;
            File currentFile = null;
            String[] filesToImport = null;
            Integer typeOfFileToImport = null;
            X509Certificate archivedSigningCertificate = null;
            X509Certificate signingCertificate = null;
            String serverCertFileName = null;
            File tempChainFile = null;
            String savedKeyFileName = null;
            CertPrincipal tempSubject = null;
            ServerCert serverCert = null;
            String panelName = null;
            boolean certInstalled = false;
            boolean shutdownStarted = false;
            String errorMessage = null;
            boolean showError = false;
            Trace.trace(TRACE_MASKT, "->service(" + request + "," + response + ")");
            try {
                if (request.isInitialRequest()) {
                    try {
                        serverCert = new ServerCert(CertUtils.getConfiguredServerCertFileName());
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    this.showCert(serverCert, "ServerCertPanel", response, false);
                    break block109;
                }
                if (request.isCanceled() || request.isDisposed()) {
                    panelName = (String)request.getSource();
                    if ("ServerCertPanel".equals(panelName)) {
                        Trace.trace(TRACE_MASKF, "terminating the task");
                        response.terminate();
                        break block109;
                    } else {
                        Trace.trace(TRACE_MASKF, "disposing panel " + panelName);
                        response.dispose();
                    }
                    break block109;
                }
                source = (String)request.getData("Source");
                Trace.trace(TRACE_MASKF, "source for the service() method is: " + source);
                actionCommand = (String)request.getData("Action");
                Trace.trace(TRACE_MASKF, "actionCommand for the service() method is: " + actionCommand);
                data = (Serializable)request.getData("Data");
                Trace.trace(TRACE_MASKF, "data for the service() method is: " + data);
                data2 = (Serializable)request.getData("Data2");
                Trace.trace(TRACE_MASKF, "data2 for the service() method is: " + data2);
                certificate = (ServerCert)request.getData("Cert");
                Trace.trace(TRACE_MASKF, "certificate for the service() method is: " + certificate);
                if (actionCommand.equals("CreateMenu.NewServerCertificateMenuItem")) {
                    response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "SigningChoicePanel", new SigningChoiceBean("SigningChoicePanel"));
                    break block109;
                }
                if (actionCommand.equals("SigningChoiceOKButton")) {
                    response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "NewServerCertPanel", new NewServerCertBean(null, "NewServerCertPanel", (Boolean)data));
                    break block109;
                }
                if (actionCommand.equals("SelectedMenu.ModifyMenuItem")) {
                    Trace.trace(TRACE_MASKD, "row " + (Integer)data + " was selected");
                    switch ((Integer)data) {
                        case 6: {
                            response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "ModifyServerCertPanel", new ModifyCertBean(certificate, "ModifyServerCertPanel"));
                            break;
                        }
                        case 4: {
                            response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "ModifyServerCertExpPanel", new ModifyCertExpBean("ModifyServerCertPanel"));
                            break;
                        }
                        case 5: {
                            response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "ModifyServerCertPanel", new NewServerCertBean(certificate, "NewServerCertPanel", certificate.isSelfSigned()));
                            break;
                        }
                        default: {
                            this.showNotSupportedMessageBox(response);
                            break;
                        }
                    }
                    break block109;
                }
                if (actionCommand.equals("finishModSubjectAltNames")) {
                    Trace.trace(TRACE_MASKD, "Subject alt names finished: " + data);
                    taskletData = new HashMap();
                    taskletData.put("SUBJECT_ALT_NAMES", data);
                    response.setMultipleResponseMode();
                    response.dispose();
                    response.update("ServerCertPanel", taskletData);
                    break block109;
                }
                if (actionCommand.equals("finishModExp")) {
                    Trace.trace(TRACE_MASKD, "Expiration finished: " + data);
                    taskletData = new HashMap();
                    taskletData.put("EXPIRATION", data);
                    response.setMultipleResponseMode();
                    response.dispose();
                    response.update("ServerCertPanel", taskletData);
                    break block109;
                }
                if (actionCommand.equals("finishSubject")) {
                    taskletData = new HashMap<String, Serializable>();
                    taskletData.put("SUBJECT", data);
                    response.setMultipleResponseMode();
                    response.dispose();
                    response.update("ServerCertPanel", taskletData);
                    break block109;
                }
                if (actionCommand.equals("ArchivedServerCertActionsMenu.InstallMenuItem")) {
                    Trace.trace(TRACE_MASKD, "Installing archived certificate of " + certificate);
                    taskletData = new HashMap();
                    taskletData.put("NEW_CERTIFICATE", certificate);
                    response.setMultipleResponseMode();
                    response.dispose();
                    response.update("ServerCertPanel", taskletData);
                    break block109;
                }
                if (actionCommand.equals("ArchivedServerCertActionsMenu.ViewArchivedSigningCertificateMenuItem")) {
                    issuer = (CertPrincipal)data;
                    archivedSigningCertificate = CertUtils.findArchivedX509SigningCertificate(issuer);
                    if (archivedSigningCertificate != null) {
                        this.showArchivedSigningCert(new ServerCert(archivedSigningCertificate), "ArchivedSigningCertPanel", response, true);
                        break block109;
                    } else {
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0052"), response);
                        response.noAction();
                    }
                    break block109;
                }
                if (actionCommand.equals("AdvancedMenu.WorkWithArchivedServerCertificateMenuItem")) {
                    try {
                        archivedCertificate = new ServerCert(CertUtils.getConfiguredArchivedServerCertFileName());
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    if (archivedCertificate != null) {
                        this.showArchivedCert(archivedCertificate, "ArchivedServerCertPanel", response, true);
                        break block109;
                    } else {
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0035"), response);
                        response.noAction();
                    }
                    break block109;
                }
                if (actionCommand.equals("AdvancedMenu.ImportServerCertificateMenuItem")) {
                    qualifiedDevices = CertUtils.getRemovableMediaDevices();
                    if (qualifiedDevices.size() > 0) {
                        response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "RemovableMediaChoicePanel", new RemovableMediaChoiceBean(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "ImportMediaIntroLabel"), qualifiedDevices, (Serializable)((Object)new String()), "RemovableMediaChoicePanel"));
                        break block109;
                    } else {
                        Trace.trace(TRACE_MASKF, "There are no removable media devices to import from.");
                        new FrameworkLog(CertMgtConstants.LOG_INFO, 15).log();
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0047"), response);
                        response.dispose();
                    }
                    break block109;
                }
                if (actionCommand.equals("AdvancedMenu.ViewSigningCertificateMenuItem")) {
                    if (certificate != null) {
                        issuer = certificate.getIssuerX500Principal();
                        if (issuer != null) {
                            if (certificate.isSelfSigned()) {
                                this.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0039"), response);
                                response.noAction();
                                break block109;
                            }
                            signingCertificate = CertUtils.findX509SigningCertificate(issuer);
                            if (signingCertificate != null) {
                                response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "SigningCertPanel", new SigningCertMgtBean(new ServerCert(signingCertificate), "SigningCertPanel"));
                                break block109;
                            } else {
                                this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0053"), response);
                                response.noAction();
                            }
                            break block109;
                        }
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0037"), response);
                        response.noAction();
                        break block109;
                    }
                    this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0038"), response);
                    response.noAction();
                    break block109;
                }
                if (actionCommand.equals("finishSelfSignedServerCert")) {
                    errorMessage = null;
                    showError = true;
                    partialServerCert = (SelfSignedServerCert)data;
                    try {
                        tempCertificate = this.createCert(partialServerCert, true);
                    }
                    catch (UnknownHostException e) {
                        errorMessage = "0065";
                    }
                    catch (HException e) {
                        answer = this.showQuestionMessageBox("0042", "0066");
                        if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                            try {
                                tempCertificate = this.createCert(partialServerCert, false);
                            }
                            catch (UnknownHostException e2) {
                                errorMessage = "0065";
                            }
                            catch (HException e2) {}
                        }
                        response.setMultipleResponseMode();
                        response.dispose();
                        response.dispose();
                        showError = false;
                    }
                    if (tempCertificate != null) {
                        taskletData = new HashMap<String, Serializable>();
                        taskletData.put("NEW_CERTIFICATE", tempCertificate);
                        response.setMultipleResponseMode();
                        response.dispose();
                        response.dispose();
                        response.update("ServerCertPanel", taskletData);
                        break block109;
                    }
                    if (showError) {
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", errorMessage != null ? errorMessage : "0021"), response);
                        response.dispose();
                    }
                    break block109;
                }
                if (actionCommand.equals("finishCASignedServerCert")) {
                    taskletData = new HashMap();
                    taskletData.put("SELF_SIGNED_SERVER_CERT", data);
                    qualifiedDevices = CertUtils.getRemovableMediaDevices();
                    if (qualifiedDevices.size() > 0) {
                        response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "RemovableMediaChoicePanel", new RemovableMediaChoiceBean(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "RemovableMediaChoicePanelIntroLabel"), qualifiedDevices, taskletData, "RemovableMediaChoicePanel"));
                        break block109;
                    } else {
                        Trace.trace(TRACE_MASKF, "There are no removable media devices to write the certificate signing request to.");
                        new FrameworkLog(CertMgtConstants.LOG_INFO, 15).log();
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0040"), response);
                        response.dispose();
                    }
                    break block109;
                }
                if (actionCommand.equals("RemovableMediaChoiceOKButton")) {
                    internalDeviceName = (String)((Object)data);
                    if (data2 instanceof HashMap) {
                        partialServerCert = (SelfSignedServerCert)((HashMap)data2).get("SELF_SIGNED_SERVER_CERT");
                        devices = MediaServices.getMediaServices().getMediaDeviceIdentifiers();
                        if (devices == null) break block109;
                        chosenDevice = CertMgtTasklet.getChosenDevice(devices, internalDeviceName);
                        if (chosenDevice != null) {
                            savedKeyFileName = CertUtils.getSavedKeyFileName();
                            if (savedKeyFileName != null) {
                                if (this.showReadyToWriteBox()) {
                                    errorMessage = null;
                                    try {
                                        tempCertificate = this.createCert(partialServerCert, true);
                                    }
                                    catch (UnknownHostException e) {
                                        errorMessage = "0063";
                                    }
                                    catch (HException e) {
                                        errorMessage = "0064";
                                    }
                                    if (tempCertificate != null) {
                                        try {
                                            hostName = CertMgtTasklet.getFQHostName(true);
                                        }
                                        catch (UnknownHostException e) {
                                            errorMessage = "0063";
                                        }
                                        catch (HException e) {
                                            errorMessage = "0064";
                                        }
                                        if (errorMessage == null) {
                                            block110: {
                                                tempSubject = partialServerCert.getSubject();
                                                certSignReq = new CertSignReq(tempSubject != null ? tempSubject.getCountry() : null, tempSubject != null ? tempSubject.getState() : null, tempSubject != null ? tempSubject.getLocality() : null, tempSubject != null ? tempSubject.getOrg() : null, tempSubject != null ? tempSubject.getOrgUnit() : null, hostName, tempSubject != null ? tempSubject.getEMailAddr() : null, tempCertificate.getAlternateDNSNames(), tempCertificate.getIPAddresses());
                                                try {
                                                    mediaDevice = null;
                                                    mediaDevice = new MediaServicesUtil(this).prepareMedia(chosenDevice, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "certMgtTasklet"), true, null);
                                                    mediaMountPointFile = mediaDevice.getMountPoint();
                                                    mediaMountPoint = mediaMountPointFile.getCanonicalPath();
                                                    certSignReq.writeToFile(mediaMountPoint + File.separator + "server.csr", savedKeyFileName);
                                                    Object var49_56 = null;
                                                    if (mediaDevice == null) break block110;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var49_57 = null;
                                                    if (mediaDevice != null) {
                                                        mediaDevice.unlock();
                                                    }
                                                    throw throwable;
                                                }
                                                mediaDevice.unlock();
                                            }
                                            if ((answer = this.showQuestionMessageBox("0042", "0043")).equals(CommonMsgInterface.YES_BUTTON)) {
                                                taskletData = new HashMap();
                                                taskletData.put("NEW_CERTIFICATE", tempCertificate);
                                                response.setMultipleResponseMode();
                                                response.dispose();
                                                response.dispose();
                                                response.dispose();
                                                response.update("ServerCertPanel", taskletData);
                                                break block109;
                                            } else {
                                                response.dispose();
                                                response.dispose();
                                                response.dispose();
                                            }
                                            break block109;
                                        }
                                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", errorMessage), response);
                                        response.noAction();
                                        break block109;
                                    }
                                    this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", errorMessage != null ? errorMessage : "0046"), response);
                                    response.noAction();
                                    break block109;
                                }
                                response.dispose();
                                response.dispose();
                                response.dispose();
                                break block109;
                            }
                            this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0046"), response);
                            response.noAction();
                            break block109;
                        }
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0044"), response);
                        response.noAction();
                        break block109;
                    }
                    devices = MediaServices.getMediaServices().getMediaDeviceIdentifiers();
                    if (devices == null) break block109;
                    chosenDevice = CertMgtTasklet.getChosenDevice(devices, internalDeviceName);
                    if (chosenDevice != null) {
                        try {
                            block111: {
                                mediaDevice = null;
                                mediaDevice = new MediaServicesUtil(this).prepareMedia(chosenDevice, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "certMgtTasklet"), true, null);
                                mediaMountPointFile = mediaDevice.getMountPoint();
                                files = mediaMountPointFile.listFiles();
                                if (files != null) {
                                    filesToList = new ArrayList<String>();
                                    int i = 0;
                                    while (true) {
                                        if (i >= files.length) {
                                            if (filesToList.size() <= 0) break;
                                            taskletData = new HashMap();
                                            taskletData.put("IMPORT_TYPE", new Integer(1));
                                            taskletData.put("FILES_TO_LIST", filesToList);
                                            taskletData.put("REMOVABLE_DEVICE", (Serializable)((Object)internalDeviceName));
                                            response.replace("com.ibm.hwmca.fw.certs.res.CertMgt", "ListBoxPanel", new ListBoxBean(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "SelectServerCertIntroLabel"), filesToList, taskletData, true, false, "ListBoxPanel"));
                                            break block111;
                                        }
                                        currentFile = files[i];
                                        if (!currentFile.isDirectory()) {
                                            filesToList.add(currentFile.getCanonicalPath());
                                        }
                                        ++i;
                                    }
                                    this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0049"), response);
                                    response.noAction();
                                } else {
                                    this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0050"), response);
                                    response.noAction();
                                }
                            }
                            Object var51_59 = null;
                            if (mediaDevice == null) break block109;
                        }
                        catch (Throwable throwable) {
                            Object var51_60 = null;
                            if (mediaDevice != null) {
                                mediaDevice.unlock();
                            }
                            throw throwable;
                        }
                        mediaDevice.unlock();
                        break block109;
                    }
                    this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0044"), response);
                    response.noAction();
                    break block109;
                }
                if (actionCommand.equals("ListBoxOKButton")) {
                    filesToImport = (String[])data;
                    taskletData = (HashMap<String, Serializable>)data2;
                    typeOfFileToImport = (Integer)taskletData.get("IMPORT_TYPE");
                    if (typeOfFileToImport != null) {
                        if (typeOfFileToImport == 1) {
                            newTaskletData = new HashMap<String, Object>();
                            newTaskletData.put("IMPORT_TYPE", new Integer(2));
                            newTaskletData.put("SERVER_CERT_FILE_NAME", filesToImport[0]);
                            newTaskletData.put("REMOVABLE_DEVICE", (String)taskletData.get("REMOVABLE_DEVICE"));
                            response.replace("com.ibm.hwmca.fw.certs.res.CertMgt", "ListBoxPanel", new ListBoxBean(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "SelectSigningCertsIntroLabel"), (ArrayList)taskletData.get("FILES_TO_LIST"), newTaskletData, false, true, "ListBoxPanel"));
                            break block109;
                        }
                        serverCertFileName = (String)taskletData.get("SERVER_CERT_FILE_NAME");
                        if (serverCertFileName != null) {
                            savedKeyFileName = CertUtils.getSavedKeyFileName();
                            if (savedKeyFileName != null) {
                                devices = MediaServices.getMediaServices().getMediaDeviceIdentifiers();
                                if (devices != null) {
                                    chosenDevice = CertMgtTasklet.getChosenDevice(devices, (String)taskletData.get("REMOVABLE_DEVICE"));
                                    if (chosenDevice != null) {
                                        try {
                                            certInstalled = false;
                                            mediaDevice = null;
                                            mediaDevice = new MediaServicesUtil(this).prepareMedia(chosenDevice, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "certMgtTasklet"), false, null);
                                            if (filesToImport != null) {
                                                if (filesToImport.length > 1) {
                                                    try {
                                                        tempChainFile = CertUtils.concatenateCerts(filesToImport);
                                                        CertUtils.install(serverCertFileName, savedKeyFileName, tempChainFile.getCanonicalPath());
                                                        certInstalled = true;
                                                        new File(savedKeyFileName).delete();
                                                        Object var53_62 = null;
                                                        if (tempChainFile != null) {
                                                            tempChainFile.delete();
                                                        }
                                                        break block109;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var53_63 = null;
                                                        if (tempChainFile != null) {
                                                            tempChainFile.delete();
                                                        }
                                                        throw throwable;
                                                    }
                                                }
                                                CertUtils.install(serverCertFileName, savedKeyFileName, filesToImport[0]);
                                                certInstalled = true;
                                                break block109;
                                            }
                                            CertUtils.install(serverCertFileName, savedKeyFileName, null);
                                            certInstalled = true;
                                            break block109;
                                        }
                                        finally {
                                            if (mediaDevice != null) {
                                                mediaDevice.unlock();
                                            }
                                            if (certInstalled) {
                                                this.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0055"), response);
                                                try {
                                                    shutdownStarted = ShutdownManager.restartApplication(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "certMgtName"), new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "restartReason"), null);
                                                }
                                                catch (ShutdownInProcessException e) {
                                                    shutdownStarted = true;
                                                }
                                                if (shutdownStarted) {
                                                    response.noAction();
                                                } else {
                                                    try {
                                                        serverCert = new ServerCert(CertUtils.getConfiguredServerCertFileName());
                                                    }
                                                    catch (FileNotFoundException e) {
                                                        serverCert = null;
                                                    }
                                                    if (serverCert != null) {
                                                        this.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0055"), response);
                                                        taskletData = new HashMap();
                                                        taskletData.put("NEW_STATE", serverCert);
                                                        response.setMultipleResponseMode();
                                                        response.dispose();
                                                        response.update("ServerCertPanel", taskletData);
                                                    } else {
                                                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0061"), response);
                                                        response.noAction();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051"), response);
                                    response.noAction();
                                    break block109;
                                }
                                this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051"), response);
                                response.noAction();
                                break block109;
                            }
                            this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051"), response);
                            response.noAction();
                            break block109;
                        }
                        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051"), response);
                        response.noAction();
                        break block109;
                    }
                    this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051"), response);
                    response.noAction();
                    break block109;
                }
                if (actionCommand.equals("ServerCertApplyButton")) {
                    this.applyChanges((ServerCert)data, certificate, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown event received in service(...).");
                    new FrameworkLog(CertMgtConstants.LOG_INFO, 2).log();
                }
            }
            catch (Throwable t) {
                Trace.trace(TRACE_MASKF, "Throwable caught in service(): " + t);
                new FrameworkLog(CertMgtConstants.LOG_INFO, 3, t).log();
                throw new TaskletException(t);
            }
        }
        Trace.trace(TRACE_MASKT, "<-service(...)");
    }

    private void showErrorMessageBox(MessageText messageText, PanelTaskletResponse response) {
        try {
            this.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0020"), messageText, MsgType.ERROR_MESSAGE, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
    }

    private void showInfoMessageBox(MessageText messageText, PanelTaskletResponse response) {
        try {
            this.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0023"), messageText, MsgType.INFORMATION_MESSAGE, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
    }

    private void showNotSupportedMessageBox(PanelTaskletResponse response) {
        try {
            this.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0001"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0002"), MsgType.INFORMATION_MESSAGE, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
        response.noAction();
    }

    private void showNoChangesMessageBox(PanelTaskletResponse response) {
        this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0028"), response);
    }

    private LocalizableText showQuestionMessageBox(String titleKey, String questionKey) {
        LocalizableText answer = null;
        try {
            answer = this.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", titleKey), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", questionKey), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
            answer = CommonMsgInterface.NO_BUTTON;
        }
        return answer;
    }

    private boolean showReadyToWriteBox() {
        LocalizableText answer = null;
        boolean result = false;
        try {
            answer = this.showMessageBox(true, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0023"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0041"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
            if (answer.equals(CommonMsgInterface.OK_BUTTON)) {
                result = true;
            }
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "TaskletException while showing message box: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
        }
        return result;
    }

    public void logException(Throwable throwable) {
        new FrameworkLog(CertMgtConstants.LOG_INFO, 5, throwable).log();
    }

    private void showCert(ServerCert certificate, String panelName, PanelTaskletResponse response, boolean modalChildWindow) {
        CertMgtBean bean = null;
        bean = new CertMgtBean(certificate, panelName);
        if (modalChildWindow) {
            response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", panelName, bean);
        } else {
            response.replace("com.ibm.hwmca.fw.certs.res.CertMgt", "ServerCertPanel", bean);
        }
    }

    private void showArchivedCert(ServerCert certificate, String panelName, PanelTaskletResponse response, boolean modalChildWindow) {
        ArchivedServerCertBean bean = null;
        bean = new ArchivedServerCertBean(certificate, panelName);
        if (modalChildWindow) {
            response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", panelName, bean);
        } else {
            response.replace("com.ibm.hwmca.fw.certs.res.CertMgt", "ArchivedServerCertPanel", bean);
        }
    }

    private void showArchivedSigningCert(ServerCert certificate, String panelName, PanelTaskletResponse response, boolean modalChildWindow) {
        ArchivedSigningCertBean bean = null;
        bean = new ArchivedSigningCertBean(certificate, panelName);
        if (modalChildWindow) {
            response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", panelName, bean);
        } else {
            response.replace("com.ibm.hwmca.fw.certs.res.CertMgt", "ArchivedSigningCertPanel", bean);
        }
    }

    private void applyChanges(ServerCert originalCertificate, ServerCert currentCertificate, PanelTaskletResponse response) {
        block32: {
            Trace.trace(TRACE_MASKT, "-> applyChanges");
            LocalizableText answer = null;
            HashMap<String, ServerCert> taskletData = null;
            Object qualifiedDevices = null;
            ServerCert installedServerCert = null;
            boolean shutdownStarted = false;
            if (currentCertificate == null) {
                Trace.trace(TRACE_MASKF, "There is no current certificate");
                if (originalCertificate == null) {
                    Trace.trace(TRACE_MASKF, "There was no certificate when the user started and there is none now");
                    this.showNoChangesMessageBox(response);
                    response.noAction();
                } else {
                    Trace.trace(TRACE_MASKF, "There was a certificate when the user started but there is none now");
                    Trace.trace(TRACE_MASKF, "Prompting user to archive and delete existing certificate");
                    answer = this.showQuestionMessageBox("0005", "0006");
                    if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                        Trace.trace(TRACE_MASKF, "User said yes to archive and delete");
                        try {
                            CertUtils.archiveAndDelete(originalCertificate);
                            this.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0029"), response);
                            taskletData = new HashMap<String, ServerCert>();
                            taskletData.put("NEW_STATE", null);
                            response.update("ServerCertPanel", taskletData);
                        }
                        catch (HException e) {
                            Trace.trace(TRACE_MASKF, e);
                            this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0030"), response);
                            response.noAction();
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "User said no to archive and delete");
                        response.noAction();
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "There is a current certificate");
                if (originalCertificate == null) {
                    Trace.trace(TRACE_MASKF, "There was no certificate when the user started but there is one now");
                    Trace.trace(TRACE_MASKF, "Prompting the user to install the new certificate");
                    answer = this.showQuestionMessageBox("0024", "0025");
                    if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                        Trace.trace(TRACE_MASKF, "User said yes to install certificate");
                        try {
                            CertMgtTasklet.doInstallSelfSigned(currentCertificate);
                            this.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0031"), response);
                            Trace.trace(TRACE_MASKF, "Installed certificate successfully.. restarting");
                            try {
                                shutdownStarted = ShutdownManager.restartApplication(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "certMgtName"), new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "restartReason"), null);
                            }
                            catch (ShutdownInProcessException e) {
                                shutdownStarted = true;
                            }
                            if (shutdownStarted) {
                                response.noAction();
                                break block32;
                            }
                            Trace.trace(TRACE_MASKF, "The request to start shutdown was rejected by a local user");
                            try {
                                installedServerCert = new ServerCert(CertUtils.getConfiguredServerCertFileName());
                            }
                            catch (FileNotFoundException e) {
                                Trace.trace(TRACE_MASKF, "We do not have a server cert - unexpected");
                                Trace.trace(TRACE_MASKF, e);
                                installedServerCert = null;
                            }
                            if (installedServerCert != null) {
                                Trace.trace(TRACE_MASKF, "Updating panel with new certificate");
                                taskletData = new HashMap();
                                taskletData.put("NEW_STATE", installedServerCert);
                                response.update("ServerCertPanel", taskletData);
                                break block32;
                            }
                            Trace.trace(TRACE_MASKF, "Install was ok, but panel can not be updated");
                            this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0061"), response);
                            response.noAction();
                        }
                        catch (HException e) {
                            Trace.trace(TRACE_MASKF, e);
                            this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0032"), response);
                            response.noAction();
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "User said no to install certificate");
                        response.noAction();
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "There was a certificate when the user started and there is one now");
                    if (currentCertificate.equals(originalCertificate)) {
                        Trace.trace(TRACE_MASKF, "Current and original certificate are the same.. doing nothing");
                        this.showNoChangesMessageBox(response);
                        response.noAction();
                    } else {
                        Trace.trace(TRACE_MASKF, "Prompting user to replace certificate");
                        answer = this.showQuestionMessageBox("0026", "0027");
                        if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                            Trace.trace(TRACE_MASKF, "User said yes to replace certificate");
                            try {
                                CertMgtTasklet.doInstallSelfSigned(currentCertificate);
                                this.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0033"), response);
                                Trace.trace(TRACE_MASKF, "Replaced certificate successfully.. restarting");
                                try {
                                    shutdownStarted = ShutdownManager.restartApplication(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "certMgtName"), new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "restartReason"), null);
                                }
                                catch (ShutdownInProcessException e) {
                                    shutdownStarted = true;
                                }
                                if (shutdownStarted) {
                                    response.noAction();
                                    break block32;
                                }
                                Trace.trace(TRACE_MASKF, "Shutdown request rejected by local user");
                                try {
                                    installedServerCert = new ServerCert(CertUtils.getConfiguredServerCertFileName());
                                }
                                catch (FileNotFoundException e) {
                                    Trace.trace(TRACE_MASKF, "No server cert file found - unexpected");
                                    Trace.trace(TRACE_MASKF, e);
                                    installedServerCert = null;
                                }
                                if (installedServerCert != null) {
                                    Trace.trace(TRACE_MASKF, "Updating panel with new certificate");
                                    taskletData = new HashMap();
                                    taskletData.put("NEW_STATE", installedServerCert);
                                    response.update("ServerCertPanel", taskletData);
                                    break block32;
                                }
                                Trace.trace(TRACE_MASKF, "Install was ok but couldn't update panel");
                                this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0061"), response);
                                response.noAction();
                            }
                            catch (HException e) {
                                Trace.trace(TRACE_MASKF, e);
                                this.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0034"), response);
                                response.noAction();
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "User said no to replace certificate");
                            response.noAction();
                        }
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- applyChanges");
    }

    private static void doInstallSelfSigned(ServerCert certificate) throws HException {
        Trace.trace(TRACE_MASKT, "-> doInstallSelfSigned");
        String tempServerCertFileName = null;
        String tempServerKeyFileName = null;
        File tempServerCertFile = null;
        File tempServerKeyFile = null;
        File tempDir = null;
        String tempDirName = null;
        try {
            tempDirName = BaseFileControl.getFilePath("tmp");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
        }
        if (tempDirName == null) {
            throw new HException("Temporary directory can not be determined.");
        }
        tempDir = new File(tempDirName);
        try {
            tempServerCertFile = File.createTempFile(TRACE_MASKT, null, tempDir);
            tempServerKeyFile = File.createTempFile(TRACE_MASKT, null, tempDir);
            tempServerCertFileName = tempServerCertFile.getCanonicalPath();
            tempServerKeyFileName = tempServerKeyFile.getCanonicalPath();
            Trace.trace(TRACE_MASKF, "created temp file tempServerCertFileName: " + tempServerCertFileName);
            Trace.trace(TRACE_MASKF, "created temp file tempServerKeyFileName: " + tempServerKeyFileName);
            certificate.writeToFile(tempServerCertFileName, tempServerKeyFileName);
            CertUtils.install(tempServerCertFileName, tempServerKeyFileName, null);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, e);
            throw new HException(e);
        }
        finally {
            if (tempServerCertFile != null) {
                tempServerCertFile.delete();
            }
            if (tempServerKeyFile != null) {
                tempServerKeyFile.delete();
            }
        }
        Trace.trace(TRACE_MASKT, "<- doInstallSelfSigned");
    }

    private ServerCert createCert(SelfSignedServerCert partialServerCert, boolean enforceDomainPresent) throws UnknownHostException, HException {
        Trace.trace(TRACE_MASKT, "-> createCert(..., " + enforceDomainPresent + ")");
        SelfSignedServerCert result = null;
        HashSet<String> altDNSNames = null;
        HashSet altIPAddresses = null;
        String shortHostName = null;
        Object serverCert = null;
        String hostName = null;
        CertPrincipal tempSubject = null;
        altDNSNames = partialServerCert.getAlternateDNSNames();
        if (altDNSNames == null) {
            altDNSNames = new HashSet<String>();
        }
        if ((altIPAddresses = partialServerCert.getIPAddresses()) == null) {
            altIPAddresses = new HashSet();
        }
        altIPAddresses = CertUtils.addIPAddresses(altIPAddresses);
        hostName = CertMgtTasklet.getFQHostName(enforceDomainPresent);
        if (enforceDomainPresent || CertUtils.isFullyQualifiedHostName(hostName)) {
            shortHostName = CertUtils.getShortHostName(hostName);
            if (shortHostName != null && shortHostName.length() > 0) {
                altDNSNames.add(shortHostName);
            }
        } else {
            Trace.trace(TRACE_MASKF, "The canonical host name is not valid: " + hostName);
        }
        tempSubject = partialServerCert.getSubject();
        result = new SelfSignedServerCert(partialServerCert.getNumOfDays(), tempSubject != null ? tempSubject.getCountry() : null, tempSubject != null ? tempSubject.getState() : null, tempSubject != null ? tempSubject.getLocality() : null, tempSubject != null ? tempSubject.getOrg() : null, tempSubject != null ? tempSubject.getOrgUnit() : null, hostName, tempSubject != null ? tempSubject.getEMailAddr() : null, altDNSNames, altIPAddresses);
        Trace.trace(TRACE_MASKT, "<- createCert");
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFQHostName(boolean enforceDomainPresent) throws UnknownHostException, HException {
        InetAddress localHost = null;
        String hostName = null;
        String result = null;
        boolean isFullyQualified = false;
        String exceptionString = null;
        localHost = InetAddress.getLocalHost();
        if (localHost != null) {
            hostName = localHost.getCanonicalHostName();
            if (hostName != null && hostName.length() > 0) {
                isFullyQualified = CertUtils.isFullyQualifiedHostName(hostName);
                if (isFullyQualified) {
                    return hostName;
                }
                if (!enforceDomainPresent) return hostName;
                throw new HException("The host name of the HMC is not fully qualified.");
            }
            exceptionString = "InetAddress.getCanonicalHostName() returned null or an empty string.";
            Trace.trace(TRACE_MASKF, exceptionString);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 1).log();
            throw new UnknownHostException(exceptionString);
        }
        exceptionString = "InetAddress.getLocalHost() returned null.";
        Trace.trace(TRACE_MASKF, exceptionString);
        new FrameworkLog(CertMgtConstants.LOG_INFO, 1).log();
        throw new UnknownHostException(exceptionString);
    }

    private static MediaDeviceIdentifier getChosenDevice(MediaDeviceIdentifier[] devices, String internalDeviceName) {
        MediaDeviceIdentifier currentDevice = null;
        MediaDeviceIdentifier result = null;
        String currentDeviceInternalName = null;
        int i = 0;
        while (i < devices.length) {
            currentDevice = devices[i];
            if (currentDevice != null && (currentDeviceInternalName = currentDevice.getInternalDeviceName()) != null && currentDeviceInternalName.equals(internalDeviceName)) {
                result = currentDevice;
                break;
            }
            ++i;
        }
        return result;
    }
}

